#include "ODEWheelJoint.h"

namespace PhysicsEngine
{

ODEWheelJoint::ODEWheelJoint()
{
}

ODEWheelJoint::ODEWheelJoint(dWorldID world, int objectid, IPhysicalBody *body1, IPhysicalBody *body2, Vector3f axis1, Vector3f axis2, float hardness, float bounciness, float maxtorque): IPhysicalWheelJoint(objectid, body1, body2, axis1, axis2, hardness, bounciness, maxtorque), ODEJoint(world)
{
	//body1 chassis, body2 wheel
	dGeomID idbody1=0;
	if (ODEBox *odebox = dynamic_cast<ODEBox *>(body1))
	{
		idbody1 = odebox->GetGeomId();
	}
	else if (ODEWheelCylinder *odewheelcylinder = dynamic_cast<ODEWheelCylinder *>(body1))
	{
		idbody1 = odewheelcylinder->GetGeomId();
	}
	else if (ODESphere *odesphere = dynamic_cast<ODESphere *>(body1))
	{
		idbody1 = odesphere->GetGeomId();
	}
	dGeomID idbody2=0;
	if (ODEBox *odebox = dynamic_cast<ODEBox *>(body2))
	{
		idbody2 = odebox->GetGeomId();
	}
	else if (ODEWheelCylinder *odewheelcylinder = dynamic_cast<ODEWheelCylinder *>(body2))
	{
		idbody2 = odewheelcylinder->GetGeomId();
	}
	else if (ODESphere *odesphere = dynamic_cast<ODESphere *>(body2))
	{
		idbody2 = odesphere->GetGeomId();
	}
	dJointID jointId;
	jointId = dJointCreateHinge2 (world,0);
	dJointAttach (jointId,dGeomGetBody(idbody1),dGeomGetBody(idbody2));
	const dReal *a = dGeomGetPosition (idbody2);
	dJointSetHinge2Anchor (jointId,a[0],a[1],a[2]);
	dJointSetHinge2Axis1 (jointId,axis1.GetFirst(), axis1.GetSecond(), axis1.GetThird());
	dJointSetHinge2Axis2 (jointId,axis2.GetFirst(), axis2.GetSecond(), axis2.GetThird());
	dJointSetHinge2Param (jointId,dParamSuspensionERP,bounciness);
	dJointSetHinge2Param (jointId,dParamSuspensionCFM,hardness);
	dJointSetHinge2Param (jointId,dParamVel2,0);
	dJointSetHinge2Param (jointId,dParamFMax2, maxtorque);  
	dJointSetHinge2Param (jointId,dParamLoStop,0);
	dJointSetHinge2Param (jointId,dParamHiStop,0);
	this->SetJointId(jointId);
}

ODEWheelJoint::~ODEWheelJoint()
{
}

dJointID ODEWheelJoint::GetJointId()
{
	return jointid;
}

void ODEWheelJoint::SetJointId(dJointID id)
{
	this->jointid = id;
}


void ODEWheelJoint::ApplyJointVelocity(float vel)
{
	dJointSetHinge2Param (this->jointid,dParamVel2,vel);
}

DataWheelJoint *ODEWheelJoint::GetDataWheelJoint()
{
	return new DataWheelJoint(this->GetObjectId(),this->GetBody1()->GetObjectId(),this->GetBody2()->GetObjectId(), this->GetAxis1(),this->GetAxis2(), this->GetHardness(), this->GetBounciness(), this->GetMaxTorque(), dJointGetHinge2Param (this->jointid,dParamVel2));
								
}

void ODEWheelJoint::UpdateData()
{
	Vector3f axis1new;
	dVector3 odeaxis1;
	Vector3f axis2new;
	dVector3 odeaxis2;
	dJointGetHinge2Axis1(this->jointid,odeaxis1);
	dJointGetHinge2Axis2(this->jointid,odeaxis2);
	axis1new.SetFirst(odeaxis1[0]);
	axis1new.SetSecond(odeaxis1[1]);
	axis1new.SetThird(odeaxis1[2]);
	axis2new.SetFirst(odeaxis2[0]);
	axis2new.SetSecond(odeaxis2[1]);
	axis2new.SetThird(odeaxis2[2]);
	this->SetAxis1(axis1new);
	this->SetAxis2(axis2new);
}


}
